/* Antarmuka dengan Potensiometer - Trainer Internet of Things
 * Project : Membaca data analog potensiometer pada Aplikasi IoT KIT
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP8266 WiFi dan Firebase ESP8266
#include <ESP8266WiFi.h>
#include <FirebaseESP8266.h>

// Library OLED Display
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

// Mengatur OLED Display dengan resolusi 128x64
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET    -1
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"

// PIN Potensiometer terhubung ke PIN A0 NodeMCU
#define POT_PIN  A0

// Firebase objek dengan nama fbdo
FirebaseData fbdo;

// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";

// Variabel untuk menyimpan data ADC potensiometer
int pot_adc;
// Variabel untuk menyimpan karakter data potensiometer 
char pot_data[4];

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200);
  
  // Memulai komunikasi dengan OLED Display
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  
  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);
  
  // Membersihkan tampilan display
  display.clearDisplay();
}

void loop() {
  // Membaca data ADC potensiometer
  pot_adc = analogRead(POT_PIN);
  sprintf(pot_data, "POT: %4d", pot_adc);

  // Mengirim data sensor ke database
  // dengan alamat *user/gauge1
  Firebase.setInt(fbdo, "/" + user + "/gauge1", pot_adc);
  
  // Mencetak Teks "ADC Potensiometer" pada OLED
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(1,1);
  display.print("ADC Potensiometer"); 

  // Mencetak data potensiometer pada OLED
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(1,25);
  display.print(pot_data);      

  display.display();      // Menampilkan data
  display.clearDisplay(); // Membersihkan tampilan display       
}
